/*
 * Decompiled with CFR 0.152.
 */
package dev.doctor4t.wathe.item;

import dev.doctor4t.ratatouille.util.TextUtils;
import dev.doctor4t.wathe.Wathe;
import dev.doctor4t.wathe.game.GameFunctions;
import dev.doctor4t.wathe.index.WatheCosmetics;
import dev.doctor4t.wathe.index.WatheSounds;
import dev.doctor4t.wathe.item.ItemWithSkin;
import dev.doctor4t.wathe.util.KnifeStabPayload;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3966;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KnifeItem
extends class_1792
implements ItemWithSkin {
    public static final class_2960 ITEM_ID = Wathe.id("knife");

    public KnifeItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1271<class_1799> method_7836(class_1937 world, @NotNull class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        user.method_6019(hand);
        user.method_5783(WatheSounds.ITEM_KNIFE_PREPARE, 1.0f, 1.0f);
        return class_1271.method_22428((Object)itemStack);
    }

    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        if (clickType == class_5536.field_27014 && otherStack.method_7960()) {
            if (Wathe.isSupporter(player).booleanValue()) {
                Skin currentSkin = Skin.fromString(WatheCosmetics.getSkin(stack));
                WatheCosmetics.setSkin(player, stack, Skin.getNext(currentSkin).getName());
            }
            return true;
        }
        return false;
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        Skin skin = Skin.fromString(WatheCosmetics.getSkin(stack));
        if (skin != null) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tip.skin").method_27694(style -> style.method_36139(-8355712)).method_10852((class_2561)class_2561.method_43470((String)TextUtils.formatValueString((String)skin.tooltipName)).method_27694(style -> style.method_36139(skin.getColor()))).method_10852((class_2561)class_2561.method_43471((String)"tip.change_skin").method_27694(style -> style.method_36139(-8355712))));
        }
        super.method_7851(stack, context, tooltip, type);
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        class_1657 attacker;
        block6: {
            block5: {
                if (user.method_7325()) {
                    return;
                }
                if (remainingUseTicks >= this.method_7881(stack, user) - 10 || !(user instanceof class_1657)) break block5;
                attacker = (class_1657)user;
                if (world.field_9236) break block6;
            }
            return;
        }
        class_239 collision = KnifeItem.getKnifeTarget(attacker);
        if (collision instanceof class_3966) {
            class_3966 entityHitResult = (class_3966)collision;
            class_1297 target = entityHitResult.method_17782();
            ClientPlayNetworking.send((class_8710)new KnifeStabPayload(target.method_5628()));
        }
    }

    public static class_239 getKnifeTarget(class_1657 user) {
        return class_1675.method_49998((class_1297)user, entity -> {
            class_1657 player;
            return entity instanceof class_1657 && GameFunctions.isPlayerAliveAndSurvival(player = (class_1657)entity);
        }, (double)3.0);
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8951;
    }

    public int method_7881(class_1799 stack, class_1309 user) {
        return 100;
    }

    public static enum Skin {
        DEFAULT(-6250336, "Kitchen Knife"),
        CEREMONIAL(-2520024, "Ceremonial Dagger"),
        PICK(-7517615, "Ice Pick");

        public final int color;
        @Nullable
        public final String tooltipName;
        public final Random random;

        private Skin(int color, String tooltipName) {
            this.color = color;
            this.tooltipName = tooltipName;
            this.random = new Random();
        }

        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public int getColor() {
            return this.color;
        }

        public static Skin fromString(String name) {
            for (Skin skin : Skin.values()) {
                if (!skin.getName().equalsIgnoreCase(name)) continue;
                return skin;
            }
            return DEFAULT;
        }

        public static Skin getNext(Skin skin) {
            Skin[] values = Skin.values();
            return values[(skin.ordinal() + 1) % values.length];
        }
    }
}

